*********************************************************
***Arrowsgraph: Tertiary Attainment by Gender and Year***
*********************************************************
					
cap frame drop orderingvar				
cap frame create orderingvar
frame orderingvar{
	use " ... /LISnewsletter_publicdata.dta", clear
		/*insert directory where "LISnewsletter_publicdata.dta" is stored*/
	reshape wide tertiary gini, i(cntry sex) j(yr) string
	replace tertiary10s = tertiary90s if tertiary10s==.
 	keep if sex==3
	keep cntry tertiary10s
	rename tertiary10s tertiary
	sort cntry
	}
/*this generates a variable used to order countries based on their average educational attainment
in 2015; in case no 2015 data is available, 1995 values are used*/
	
	

use " ... /LISnewsletter_publicdata.dta", clear
	/*insert directory where "LISnewsletter_publicdata.dta" is stored*/
	
keep cntry yr sex tertiary
reshape wide tertiary, i(cntry sex) j(yr) string

drop if sex==3

frlink m:1 cntry, frame(orderingvar)
frget tertiary, from(orderingvar)

sort sex tertiary
bysort sex: gen cntry_n = _n*5
labmask cntry_n, values(cntry)
	
gen cntry_n_m = cntry_n if sex==1 
labmask cntry_n_m, values(cntry)
gen cntry_n_f = cntry_n+1 if sex==2
labmask cntry_n_f, values(cntry)
/*this generates a country ID which is sorted based on average tertiary attainment
(see above); labmask attaches value lables that can be used in the graph*/	
 
	
#delimit
graph twoway
(pcarrow tertiary90s cntry_n_m tertiary10s cntry_n_m 
if sex==1 & tertiary10s!=. & tertiary90s!=.,
horizontal barbsize(small) mcolor(gs1) lcolor(gs1))
(scatter cntry_n_m tertiary90s if sex==1,
ms(oh) msize(small) mcolor(gs1))
(scatter cntry_n_m tertiary10s if sex==1 & tertiary90s==.,
ms(arrow) msize(small) mcolor(gs1))
(pcarrow tertiary90s cntry_n_f tertiary10s cntry_n_f 
if sex==2 & tertiary10s!=. & tertiary90s!=.,
horizontal barbsize(small) mcolor(gs7) lcolor(gs7))
(scatter cntry_n_f tertiary90s if sex==2,
ms(oh) msize(small) mcolor(gs7))
(scatter cntry_n_f tertiary10s
if sex==2 & tertiary90s==.,
ms(arrow) msize(small) mcolor(gs7)),
ytick(5(5)135, noticks) ylabel(5(5)135, valuelabel angle(horizontal) grid) 
yscale(reverse) ytitle("")
xtitle("Population Share (31-65)") 
xsize(6) ysize(12)
legend(label(1 "male") label(2 "1995") label(4 "female") label(6 "2015")) 
legend(order(1 2 4 6))
title("Tertiary Attainment 1995-2015")
plotregion(margin(vlarge))
scheme(s1mono)
;
#delimit cr



***********************************************
***Arrowsgraph: Gini vs. Tertiary Attainment***
***********************************************

use " ... /LISnewsletter_publicdata.dta", clear
	/*insert directory where "LISnewsletter_publicdata.dta" is stored*/

keep if sex==3
sort cntry yr
reshape wide gini tertiary, i(cntry) j(yr) string

#delimit
graph twoway
(pcarrow gini90s tertiary90s gini10s tertiary10s, mlabel(cntry) headlabel),
ytitle("Gini (labour income)") xtitle("Tertiary attainment (%)")
title("Labour Income Inequality vs. Tertiary Attainment")
scheme(s1mono)
;
#delimit cr 